<?php
/**
 * Viveum Direct Debit
 *
 * The gateway is used for Direct Debit.
 * Copyright (c) Viveum
 *
 * @class       Gateway_Viveum_DD
 * @package     Viveum/Gateway
 * @extends     Viveum_Payment_Gateway
 * @located at  /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Direct Debit.
 */
class Gateway_Viveum_DD extends Viveum_Payment_Gateway {
	/**
	 * Identifier DD
	 *
	 * @var string $id
	 */
	public $id = 'viveum_dd';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'DIRECTDEBIT_SEPA';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/sepa.png';
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['trans_mode'] = array(
			'title' => __( 'Transaction-Mode', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'PA' => __( 'Pre-Authorization', 'wc-viveum' ),
				'DB' => __( 'Debit', 'wc-viveum' ),
			),
			'default' => 'DB',
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Direct Debit', 'wc-viveum' );
		}

		return __( 'Direct Debit', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_DD();
