<?php
/**
 * Viveum EPS
 *
 * The gateway is used for EPS.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_EPS
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for EPS.
 */
class Gateway_Viveum_EPS extends Viveum_Payment_Gateway {
	/**
	 * Identifier eps
	 *
	 * @var string $id
	 */
	public $id = 'viveum_eps';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'EPS';

	/**
	 * Payment type
	 *
	 * @var string $payment_type
	 */
	protected $payment_type = 'PA';

	/**
	 * When doing payment in TEST system. use this value as testMode parameter.
	 *
	 * @var string $test_mode
	 */
	public $test_mode = 'INTERNAL';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/eps.png';
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'EPS', 'wc-viveum' );
		}

		return __( 'EPS', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_EPS();
