<?php
/**
 * Viveum Klarna Online Bank Transfer.
 *
 * The gateway is used for Klarna Online Bank Transfer.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Klarnaobt
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Klarna Online Bank Transfer.
 */
class Gateway_Viveum_Klarnaobt extends Viveum_Payment_Gateway {
	/**
	 * Identifier Klarna Online Bank Transfer.
	 *
	 * @var string $id
	 */
	public $id = 'viveum_klarnaobt';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'SOFORTUEBERWEISUNG';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		$logo = $this->plugins_url . '/assets/images/klarnaobt.png';
		return $logo;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Online Bank Transfer.', 'wc-viveum' );
		}

		return __( 'Online Bank Transfer.', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Klarnaobt();
