<?php
/**
 * Viveum Masterpass
 *
 * The gateway is used for Masterpass.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Masterpass
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Masterpass.
 */
class Gateway_Viveum_Masterpass extends Viveum_Payment_Gateway {
	/**
	 * Identifier masterpass
	 *
	 * @var string $id
	 */
	public $id = 'viveum_masterpass';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/masterpass.png';
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Masterpass', 'wc-viveum' );
		}

		return __( 'Masterpass', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Masterpass();
