<?php
/**
 * Viveum Payments Update Order
 *
 * The file is for displaying additional information at order detail ( admin )
 * Copyright (c) Viveum
 *
 * @package     Viveum/Templates
 * @located at  /template/admin/meta-boxes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class='additional_information' style='display: block; float: left'>
	<p>
		<strong style='display: block'><?php echo esc_attr( __( 'Payment Information', 'wc-viveum' ) ); ?></strong>
		<?php
		echo esc_attr( __( 'Payment Method', 'wc-viveum' ) ) . ' : ' . esc_attr( $payment_method_title ) . '<br />';
		echo esc_attr( __( 'Currency', 'wc-viveum' ) ) . ' : ' . esc_attr( $transaction_log['currency'] ) . '<br />';
		echo esc_attr( __( 'Amount', 'wc-viveum' ) ) . ' : ' . esc_attr( $transaction_log['amount'] ) . '<br />';
		echo esc_attr( __( 'Transaction ID', 'wc-viveum' ) ) . ' : ' . esc_attr( $transaction_log['transaction_id'] ) . '<br />';
		echo esc_attr( __( 'Short ID', 'wc-viveum' ) ) . ' : ' . esc_attr( $transaction_log['short_id'] ) . '<br />';
		if( $isSubscription ) {
			echo esc_attr( __( 'Registration ID', 'wc-viveum' ) ) . ' : ' . esc_attr( $additional_information ) . '<br />';
		}
		if ( $additional_information && !$isSubscription) {
			foreach ( $additional_information as $info_name => $info_value ) {
				echo  esc_attr( Viveum_General_Functions::viveum_translate_additional_information( $info_name ) ) . ' : ' . esc_attr( $info_value ) . '<br />';
			}
		}
		?>
	</p>
</div>
