<?php
/**
 * Viveum Payments Form
 *
 * The file is for displaying the Viveum payment form
 * Copyright (c) Viveum
 *
 * @package     Viveum/Templates
 * @located at  /template/ckeckout/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<script type="text/javascript">
	var wpwlOptions = {
		locale: "<?php echo esc_attr( strtolower( substr( get_bloginfo( 'language' ), 0, 2 ) ) ) ?>",
		style: "card",
		onReady: function() {
			var buttonCancel = "<a href='<?php echo esc_attr( $url_config['cancel_url'] ) ?>' class='wpwl-button btn_cancel'><?php echo esc_attr( __( 'Cancel', 'wc-viveum' ) ) ?></a>";
			var ttTestMode = "<div class='testmode'><?php echo esc_attr( __( 'THIS IS A TEST. NO REAL MONEY WILL BE TRANSFERED', 'wc-viveum' ) ) ?></div>";
			var merchantLocation = "<div class='merchant-location-description'><?php echo esc_attr( __( 'Payee: ', 'wc-viveum' ) ) . esc_attr( $merchant_location ); ?></div>";
			jQuery( "form.wpwl-form" ).find( ".wpwl-button" ).before( buttonCancel );
			<?php if ( $merchant_location && ('viveum_cc' === $payment_method || 'viveum_ccsaved' === $payment_method) ) : ?>
				jQuery( ".wpwl-container" ).after( merchantLocation );
			<?php endif; ?>
			<?php if ( 'TEST' === $settings['server_mode'] ) : ?>
				jQuery( ".wpwl-container" ).wrap( "<div class='frametest'></div>" );
				jQuery( ".wpwl-container" ).before( ttTestMode );
			<?php endif; ?>
			<?php if ( $is_recurring && $is_one_click_payments ) : ?>
				var headerWidget = "<h3 id='deliveryHeader' style='text-align:center'><?php echo esc_attr( __( 'Use alternative payment data', 'wc-viveum' ) ) ?></h3>";
				jQuery( "#wpwl-registrations" ).after( headerWidget );
				if (jQuery('.merchant-location-description').length > 1){
		            jQuery('.merchant-location-description').eq(0).hide();
		        }
			<?php endif; ?>
		},
		registrations: {
			hideInitialPaymentForms: false,
			requireCvv: false
		}
	}
</script>
<?php if ( $is_recurring ) : ?>
	<?php if ( $is_one_click_payments ) : ?>
		<h3 id="deliveryHeader" style="text-align:center"><?php echo esc_attr( __( 'Use stored payment data', 'wc-viveum' ) ) ?></h3>
	<?php else : ?>
		<h3 id="deliveryHeader" style="text-align:center"><?php echo esc_attr( __( 'Pay and Save Payment Information', 'wc-viveum' ) ) ?></h3>
	<?php endif; ?>
<?php endif; ?>
<?php echo $payment_widget_script;?>
<form action="<?php echo esc_attr( $url_config['return_url'] ) ?>" class="paymentWidgets"><?php echo esc_attr( $payment_parameters['payment_brand'] ) ?></form>
