<?php
/**
 * Viveum Payments Deregister Form
 *
 * The file is for displaying the Viveum deregister form
 * Copyright (c) Viveum
 *
 * @package     Viveum/Templates
 * @located at  /template/ckeckout/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<h2 class="header-title"><?php echo esc_attr( __( 'Delete Payment Information', 'wc-viveum' ) ) ?></h2>

<div class="box-unreg">
	<form action="<?php echo esc_attr( $url_config['return_url'] ) ?>" method="post">
		<p class="text-unreg"><?php echo esc_attr( __( 'Are you sure to delete this payment information?', 'wc-viveum' ) ) ?></p>
		<a class="btnCustom btnLink button-primary" href="<?php echo esc_attr( $url_config['cancel_url'] ) ?>"><?php echo esc_attr( __( 'Cancel', 'wc-viveum' ) ) ?></a>
		<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Confirm', 'wc-viveum' ) ) ?></button>
	</form>
</div>

