<?php
/**
 * Viveum My Payment Information
 *
 * The file is for displaying the Viveum My Payment Information
 * Copyright (c) Viveum
 *
 * @package     Viveum/Templates
 * @located at  /template/ckecmyaccountkout/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<h2 class="header-title"><?php echo esc_attr( __( 'My Payment Information', 'wc-viveum' ) ) ?></h2>

<?php if ( isset( WC()->session->viveum_myaccount_error ) ) :?>
	<ul class="response-box error-message">
		<li><?php echo esc_attr( WC()->session->viveum_myaccount_error ); ?></li>
	</ul>
<?php
unset( WC()->session->viveum_myaccount_error );
endif; ?>

<?php if ( isset( WC()->session->viveum_myaccount_success ) ) :?>
	<ul class="response-box success-message">
		<li><?php echo esc_attr( WC()->session->viveum_myaccount_success ); ?></li>
	</ul>
<?php
unset( WC()->session->viveum_myaccount_success );
endif; ?>

<?php if ( $recurring ) :?>

	<?php if ( $is_active_cc ) : ?>
	<div class="group"><?php echo esc_attr( __( 'Credit Card', 'wc-viveum' ) ); ?></div>
	<?php if ( $registered_payments['CC'] ) :?>
		<?php foreach ( $registered_payments['CC'] as $payment ) :?>
		<div class="group-list">
			<div class="group-img">
				<img src="<?php echo esc_attr( $plugin_url ) ?>assets/images/<?php echo esc_attr( strtolower( $payment['brand'] ) ) ?>.png" class="card_logo" alt="<?php echo esc_attr( $payment['brand'] ) ?>">
			</div>
			<div class="card_info">
				<?php echo esc_attr( __( 'ending in:', 'wc-viveum' ) ) . ' ' . esc_attr( $payment['last4digits'] ) . '; ' .
				esc_attr( __( 'expires on:', 'wc-viveum' ) ) . ' ' . esc_attr( $payment['expiry_month'] ) . '/' . esc_attr( substr( $payment['expiry_year'],-2 ) ) ?>
			</div>
			<div class="group-button">
				<?php if ( $payment['payment_default'] ) :?>
					<button class="btnCustom btnDefault button-primary"><?php echo esc_attr( __( 'Default', 'wc-viveum' ) ) ?></button>
				<?php else : ?>
					<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-default" method="post">
						<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
						<input type="hidden" name="viveum_section" value="viveum_ccsaved"/>
						<button class="btnCustom btnDefault button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Set as Default', 'wc-viveum' ) ) ?></button>
					</form>
				<?php endif; ?>
				<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-reregister" method="post">
					<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
					<input type="hidden" name="viveum_section" value="viveum_ccsaved"/>
					<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Change', 'wc-viveum' ) ) ?></button>
				</form>
				<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-deregister" method="post">
					<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
					<input type="hidden" name="viveum_section" value="viveum_ccsaved"/>
					<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Delete', 'wc-viveum' ) ) ?></button>
				</form>
				<div class="clear"></div>
			</div>
			<div class="clear"></div>
		</div>
		<?php endforeach; ?>
	<?php endif; ?>
	<div class="group-add">
		<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-register" method="post">
			<input type="hidden" name="viveum_section" value="viveum_ccsaved"/>
			<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Add', 'wc-viveum' ) ) ?></button>
		</form>
	</div>
	<div class="clear"></div>
	<?php endif; ?>

	<?php if ( $is_active_dd ) : ?>
	<div class="group"><?php echo esc_attr( __( 'Direct Debit', 'wc-viveum' ) ) ?></div>
	<?php if ( $registered_payments['DD'] ) :?>
		<?php foreach ( $registered_payments['DD'] as $payment ) :?>
		<div class="group-list">
			<div class="group-img">
				<img src="<?php echo esc_attr( $plugin_url ) ?>assets/images/sepa.png" class="card_logo" alt="sepa">
			</div>
			<div class="card_info">
				<?php echo esc_attr( __( 'Account: ****', 'wc-viveum' ) ) . ' ' . esc_attr( $payment['last4digits'] );?>
			</div>
			<div class="group-button">
				<?php if ( $payment['payment_default'] ) :?>
					<button class="btnCustom btnDefault button-primary"><?php echo esc_attr( __( 'Default', 'wc-viveum' ) ) ?></button>
				<?php else : ?>
					<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-default" method="post">
						<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
						<input type="hidden" name="viveum_section" value="viveum_ddsaved"/>
						<button class="btnCustom btnDefault button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Set as Default', 'wc-viveum' ) ) ?></button>
					</form>
				<?php endif; ?>
				<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-reregister" method="post">
					<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
					<input type="hidden" name="viveum_section" value="viveum_ddsaved"/>
					<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Change', 'wc-viveum' ) ) ?></button>
				</form>
				<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-deregister" method="post">
					<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
					<input type="hidden" name="viveum_section" value="viveum_ddsaved"/>
					<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Delete', 'wc-viveum' ) ) ?></button>
				</form>
				<div class="clear"></div>
			</div>
			<div class="clear"></div>
		</div>
		<?php endforeach; ?>
	<?php endif; ?>
	<div class="group-add">
		<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-register" method="post">
			<input type="hidden" name="viveum_section" value="viveum_ddsaved"/>
			<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Add', 'wc-viveum' ) ) ?></button>
		</form>
	</div>
	<div class="clear"></div>
	<?php endif; ?>

	<?php if ( $is_active_paypal ) : ?>
	<div class="group"><?php echo esc_attr( __( 'Paypal', 'wc-viveum' ) ) ?></div>
	<?php if ( $registered_payments['PAYPAL'] ) :?>
		<?php foreach ( $registered_payments['PAYPAL'] as $payment ) :?>
		<div class="group-list">
			<div class="group-img">
				<img src="<?php echo esc_attr( $plugin_url ) ?>assets/images/paypal.png" class="card_logo" alt="paypal">
			</div>
			<div class="card_info">
				<?php echo esc_attr( __( 'Email:', 'wc-viveum' ) ) . ' ' . esc_attr( $payment['email'] );?>
			</div>
			<div class="group-button">
				<?php if ( $payment['payment_default'] ) : ?>
					<button class="btnCustom btnDefault button-primary"><?php echo esc_attr( __( 'Default', 'wc-viveum' ) ) ?></button>
				<?php else : ?>
					<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-default" method="post">
						<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
						<input type="hidden" name="viveum_section" value="viveum_paypalsaved"/>
						<button class="btnCustom btnDefault button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Set as Default', 'wc-viveum' ) ) ?></button>
					</form>
				<?php endif; ?>
				<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-reregister" method="post">
					<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
					<input type="hidden" name="viveum_section" value="viveum_paypalsaved"/>
					<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Change', 'wc-viveum' ) ) ?></button>
				</form>
				<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-deregister" method="post">
					<input type="hidden" name="id" value="<?php echo esc_attr( $payment['id'] ) ?>"/>
					<input type="hidden" name="viveum_section" value="viveum_paypalsaved"/>
					<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Delete', 'wc-viveum' ) ) ?></button>
				</form>
				<div class="clear"></div>
			</div>
			<div class="clear"></div>
		</div>
		<?php endforeach; ?>
	<?php endif; ?>
	<div class="group-add">
		<form action="<?php echo esc_attr( $current_url ) ?>viveum_page=wc-register" method="post">
			<input type="hidden" name="viveum_section" value="viveum_paypalsaved"/>
			<button class="btnCustom button-primary" type="submit" value="submit"><?php echo esc_attr( __( 'Add', 'wc-viveum' ) ) ?></button>
		</form>
	</div>
	<div class="clear"></div>
	<?php endif; ?>

<?php endif; ?>
