<?php
/**
 * Viveum Payments Form
 *
 * The file is for displaying the Viveum register form
 * Copyright (c) Viveum
 *
 * @package     Viveum/Templates
 * @located at  /template/ckeckout/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<?php if ( 'viveum_paypalsaved' === $payment_id ) : ?>

	<style>
		body, button.wpwl-button-brand {
			display:none;
		}
	</style>
	<script type="text/javascript">
		var wpwlOptions = {
			onReady: function() {
				jQuery(".wpwl-form").removeAttr('target');
				jQuery(".wpwl-button").click(); 
			}
		}
	</script>
	<input type="submit" value="Submit" style="display:none" />

<?php else : ?>
	
	<h2 class="header-title header-center"><?php echo esc_attr( $form_title ) ?></h2>
	<script type="text/javascript">
		var wpwlOptions = {
				locale: "<?php echo esc_attr( strtolower( substr( get_bloginfo( 'language' ), 0, 2 ) ) ) ?>",
				 style: "card",
				 onReady: function() {
					var buttonCancel = "<a href='<?php echo esc_attr( $url_config['cancel_url'] )?>' class='wpwl-button btn_cancel'><?php echo esc_attr( __( 'Cancel', 'wc-viveum' ) ) ?></a>";
					var buttonConfirm = "<?php echo esc_attr( $confirm_button ) ?></a>";
					var ttTestMode = "<div class='testmode'><?php echo esc_attr( __( 'THIS IS A TEST. NO REAL MONEY WILL BE TRANSFERED', 'wc-viveum' ) ) ?></div>";
					var ttRegistration = "<div class='register-tooltip'><?php echo esc_attr( __( 'A small amount (<1 &euro;) will be charged and instantly refunded to verify your account/card details.', 'wc-viveum' ) ) ?></div>";
					jQuery( "form.wpwl-form" ).find( ".wpwl-button" ).before( buttonCancel );
					jQuery( ".wpwl-button-pay" ).html( buttonConfirm );
					jQuery( ".wpwl-container" ).after( ttRegistration );
					<?php if ( 'TEST' === $register_parameters['server_mode'] ) : ?>
						jQuery( ".wpwl-container" ).wrap( "<div class='frametest'></div>" );
						jQuery( '.wpwl-container' ).before( ttTestMode );   
					<?php endif; ?>
				},
				registrations: {
					hideInitialPaymentForms: false,
					requireCvv: false
				}
			}
	</script>
<?php endif; ?>

<form action="<?php echo esc_attr( $url_config['return_url'] ) ?>" class="paymentWidgets"><?php echo esc_attr( $payment_brand ) ?></form>
